/*
 *  Copyright (c) 1992, by
 *
 *     Emanuel G. Noik
 *     noik@db.toronto.edu
 *
 *  A test program for GL.
 */

#include <gl/gl.h>
#include <gl/device.h>
#include <hershey/hershey.h>

#define N_FONTS		  6
#define SIZE		512
#define DELTA		 20
#define TEST_STRING	"This is a test"
#define CHAR_SIZE	( SIZE / ( strlen( TEST_STRING ) + 1 ) )

static CHAR Font[N_FONTS];

main()
{
   init_hershey();
   init_gl();
   loop();
}

#define FONT(S) "./../../fonts/S.fnt"

/*
 *  Initialize Hershey stuff.
 */
init_hershey()
{
   Font[0] = HersheyLoadFont( FONT(fraktur) );
   Font[1] = HersheyLoadFont( FONT(italic) );
   Font[2] = HersheyLoadFont( FONT(lombardic) );
   Font[3] = HersheyLoadFont( FONT(roman) );
   Font[4] = HersheyLoadFont( FONT(script) );
   Font[5] = HersheyLoadFont( FONT(standard) );

   HersheyCharWidth ( CHAR_SIZE );
   HersheyCharHeight( CHAR_SIZE );
}

/*
 *  Initialize GL stuff.
 */
init_gl()
{
   int gid;

   prefposition( XMAXSCREEN / 4, XMAXSCREEN * 3 / 4,
                 YMAXSCREEN / 4, YMAXSCREEN * 3 / 4 );
   gid = winopen( "Hershey Demo for GL Windows" );
   winset( gid );
   winconstraints();
   doublebuffer();
   gconfig();

/*
   ortho( (float)-XMAXSCREEN, (float)XMAXSCREEN,
          (float)-YMAXSCREEN, (float)YMAXSCREEN,
          (float)-YMAXSCREEN, (float)YMAXSCREEN );

   ortho( (float)-SIZE / 2.0, (float)SIZE * 1.5,
          (float)-SIZE / 2.0, (float)SIZE * 1.5,
          (float)-SIZE / 2.0, (float)SIZE * 1.5 );
*/

   perspective( (Angle)900, 1.0, (Coord)200.0, (Coord)800.0 );
   lookat( 0.0, 0.0, 500.0, 0.0, 0.0, 100.0, 0 );

   lsetdepth( 0xC00000, 0x3FFFFF );

   qdevice( REDRAW );
   qdevice( ESCKEY );
   qdevice( SPACEKEY );
   qdevice( F1KEY );
   qdevice( XKEY );
   qdevice( YKEY );
   qdevice( ZKEY );

   qenter( REDRAW, gid );

   /*zbuffer( TRUE );*/
}

/*
 *  Define text.
 */
define_text()
{
   Coord dy = SIZE / N_FONTS;

   pushmatrix();
   {  int i;
      float y;

      for ( i = 0, y = dy / 2.0; i < N_FONTS; i++, y += dy ) {
         color( i + 2 );
         HersheyFont( Font[i] );
         HersheyText( TEST_STRING, (Coord)CHAR_SIZE, y, y /*(Coord)(50.0)*/ );
      }
   }
   popmatrix();
}

/*
 *  Draw text.
 */
draw_text( Coord dx, Coord dy, Coord dz, Angle rx, Angle ry, Angle rz )
{
   pushmatrix();
      zclear();
      color( BLACK );
      clear();

#define OFFSET ( (Coord) -SIZE / 2.0 )

      translate( OFFSET, OFFSET, OFFSET );

      if ( rx != 0 ) rotate( rx, 'x' );
      if ( ry != 0 ) rotate( ry, 'y' );
      if ( rz != 0 ) rotate( rz, 'z' );

      if ( dx != 0.0 || dy != 0.0 || dz != 0.0 )
         translate( dx, dy, dz );

      define_text();
   popmatrix();

   swapbuffers();
}

/*
 *  Simple event loop.
 */
loop()
{
   while ( TRUE ) {
      while ( qtest() ) {
         static int old_delta = FALSE, rotate = TRUE;
         int redraw = FALSE;
         static Angle rx = 0, ry = 0, rz = 0, delta = DELTA;
         static Coord dx = 0.0, dy = 0.0, dz = 0.0;
         short key_down;
         Device dev = qread( &key_down );

         if ( ! key_down ) continue;

         switch ( dev ) {

            case ESCKEY:
               gexit();
               exit();
               break;

            case SPACEKEY:
               delta = -delta;
               break;

            case REDRAW:
               reshapeviewport();
               redraw = TRUE;
               break;

            case XKEY:
               if ( rotate ) rx += delta;
               else dx += (Coord)delta;
               redraw = TRUE;
               old_delta = TRUE;
               break;

            case YKEY:
               if ( rotate ) ry += delta;
               else dy += (Coord)delta;
               redraw = TRUE;
               old_delta = TRUE;
               break;

            case ZKEY:
               if ( rotate ) rz += delta;
               else dz += (Coord)delta;
               redraw = TRUE;
               old_delta = TRUE;
               break;

            case F1KEY:
               rotate = ! rotate;
               break;

            default:
               break;
         }

         if ( redraw )
            draw_text( dx, dy, dz, rx, ry, rz );

         qreset();
      }
   }
}
